### 43.2.1. 远程shell命令

你可以使用Groovy或Java编写其他的shell命令（具体参考CRaSH文档）。默认情况下，Spring Boot会搜索以下路径的命令：
* `classpath*:/commands/**`
* `classpath*:/crash/commands/**`

**注**：可以通过`shell.commandPathPatterns`属性改变搜索路径。

下面是一个从`src/main/resources/commands/hello.groovy`加载的'hello world'命令：
```java
package commands

import org.crsh.cli.Usage
import org.crsh.cli.Command

class hello {

    @Usage("Say Hello")
    @Command
    def main(InvocationContext context) {
        return "Hello"
    }

}
```
Spring Boot将一些额外属性添加到了InvocationContext，你可以在命令中访问它们：

|属性名称|描述|
|------|:------|
|spring.boot.version|Spring Boot的版本|
|spring.version|Spring框架的核心版本|
|spring.beanfactory|获取Spring的BeanFactory|
|spring.environment|获取Spring的Environment|
